%------------------------------------------------------------------------------
% File     : SEV317^5 : TPTP v7.4.0. Released v4.0.0.
% Domain   : Set Theory
% Problem  : TPS problem THM145-A
% Version  : Especial.
% English  : Related to the Knaster-Tarski theorem.

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0496 [Bro09]
%          : THM145-A [TPS]

% Status   : Theorem
% Rating   : 0.92 v7.4.0, 0.89 v7.3.0, 0.90 v7.2.0, 0.88 v7.1.0, 0.86 v7.0.0, 0.88 v6.4.0, 0.86 v6.3.0, 0.83 v5.5.0, 0.80 v5.4.0, 0.75 v5.3.0, 1.00 v5.1.0, 0.75 v4.1.0, 0.67 v4.0.0
% Syntax   : Number of formulae    :    2 (   0 unit;   1 type;   0 defn)
%            Number of atoms       :   60 (   0 equality;  60 variable)
%            Maximal formula depth :   14 (   8 average)
%            Number of connectives :   59 (   0   ~;   0   |;   8   &;  42   @)
%                                         (   0 <=>;   9  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    6 (   6   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    3 (   1   :;   0   =)
%            Number of variables   :   16 (   0 sgn;  15   !;   1   ?;   0   ^)
%                                         (  16   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_NEQ_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
%          : Polymorphic definitions expanded.
%------------------------------------------------------------------------------
thf(a_type,type,(
    a: $tType )).

thf(cTHM145_A_pme,conjecture,(
    ! [R: a > a > $o,U: ( a > $o ) > a] :
      ( ( ! [Xx: a,Xy: a,Xz: a] :
            ( ( ( R @ Xx @ Xy )
              & ( R @ Xy @ Xz ) )
           => ( R @ Xx @ Xz ) )
        & ! [Xs: a > $o] :
            ( ! [Xz: a] :
                ( ( Xs @ Xz )
               => ( R @ Xz @ ( U @ Xs ) ) )
            & ! [Xz: a] :
                ( ( Xs @ Xz )
               => ( R @ Xz @ ( U @ Xs ) ) )
            & ! [Xj: a] :
                ( ! [Xk: a] :
                    ( ( ( Xs @ Xk )
                      & ( Xs @ Xk ) )
                   => ( R @ Xk @ Xj ) )
               => ( ( R @ ( U @ Xs ) @ Xj )
                  & ( R @ ( U @ Xs ) @ Xj ) ) ) ) )
     => ! [Xf: a > a] :
          ( ( ! [Xx: a,Xy: a] :
                ( ( R @ Xx @ Xy )
               => ( R @ ( Xf @ Xx ) @ ( Xf @ Xy ) ) )
            & ! [Xx: a,Xy: a] :
                ( ( R @ Xx @ Xy )
               => ( R @ ( Xf @ Xx ) @ ( Xf @ Xy ) ) ) )
         => ? [Xw: a] :
              ( ( R @ Xw @ ( Xf @ Xw ) )
              & ( R @ ( Xf @ Xw ) @ Xw ) ) ) ) )).

%------------------------------------------------------------------------------
